## distribution (in tuning)

Contained in [tuning](https://docs.vespa.ai/en/reference/services-content.html#tuning). Tune the distribution algorithm used in the cluster.

| Attribute | Required |           Value           | Default |                                                                                                                                                                                                                                                                                                                                                                                                                                          Description                                                                                                                                                                                                                                                                                                                                                                                                                                          |
|-----------|----------|---------------------------|---------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| type      | optional | loose \| strict \| legacy | loose   | When the number of a nodes configured in a system changes over certain limits, the system will automatically trigger major redistributions of documents. This is to ensure that the number of buckets is appropriate for the number of nodes in the cluster. This enum value specifies how aggressive the system should be in triggering such distribution changes. The default of `loose` strikes a balance between rarely altering the distribution of the cluster and keeping the skew in document distribution low. It is recommended that you use the default mode unless you have empirically observed that it causes too much skew in load or document distribution. Note that specifying `minimum-bits` under [bucket-splitting](https://docs.vespa.ai/en/reference/services-content.html#bucket-splitting) overrides this setting and effectively "locks" the distribution in place. |

[Read more](https://docs.vespa.ai/en/reference/services-content.html#distribution_type)
